(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9029,        253]*)
(*NotebookOutlinePosition[      9735,        278]*)
(*  CellTagsIndexPosition[      9691,        274]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Normas para entregar los ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " ",
  StyleBox["Identificaci\[OAcute]n del cuaderno.",
    FontWeight->"Bold"],
  " Este cuaderno se llama \"evaluacion1b.nb\". Debes renombrarlo. Para ello \
vas a File\[Rule] Save As... y al guardarlo (debes guardarlo en el \
escritorio) le pones tus apellidos y nombre terminado en 1 (en ese orden) \
todo seguido y sin acentos. Por ejemplo, si te llamas Luis G\[OAcute]mez Ruiz \
debes llamar a tu archivo GomezRuizLuis1.nb\n",
  StyleBox["2 Comprobaci\[OAcute]n de comandos",
    FontWeight->"Bold"],
  ". Antes de entregar tu examen debes comprobar todos y cada uno de los \
comandos que has usado. Si alguno no funciona correctamente y no sabes \
corregirlo debes indicar claramente que el comando que has escrito no \
funciona correctamente. Si al ejecutar un comando se llena la pantalla de \
mensajes de error o se cuelga el ordenador, el ejercicio correspondiente ser\
\[AAcute] calificado con 0. \n",
  StyleBox["3 Borrar salidas y guardar",
    FontWeight->"Bold"],
  ". Cuando termines tu trabajo es muy importante que borres todas las \
salidas antes de guardar el cuaderno. Para ello vas a Kernel \[Rule] Delete \
all Output. \n",
  StyleBox["4 Entrega del examen",
    FontWeight->"Bold"],
  ". Entras en el SWAD (swad.ugr.es) vas a Asignatura\[Rule]An\[AAcute]lisis \
Mat.(B)\[Rule]Evaluaci\[OAcute]n\[Rule]Mis trabajos y seguidamente \
seleccionas tu archivo que antes has guardado en el escritorio y lo mandas."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normas del examen", "Subsection"],

Cell[TextData[{
  StyleBox[
  "Puedes usar la ayuda del programa y tambi\[EAcute]n los cuadernos de ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[
  " que contienen las pr\[AAcute]cticas y el trabajo que t\[UAcute] hayas \
realizado sobre ellas (los ejercicios que hayas resuelto y tus notas \
personales). Nada m\[AAcute]s. ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aqu\[IAcute] pones tu nombre", "Subsection"],

Cell[BoxData[
    \(Nombre : \n
      \(Titulaci\[OAcute]n\  : \ Ingeniero\ en\ Inform\[AAcute]tica\)\)], 
  "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  "En este ejercicio no debes hacer c\[AAcute]lculos simb\[OAcute]licos. ",
  StyleBox["Todos",
    FontSlant->"Italic"],
  " los resultados deben ser valores aproximados.\na) Crea una lista, que \
llamar\[AAcute]s \"lista1\", cuyos elementos son de la forma {x,x} donde x \
empieza en 0 y termina en 1 con incrementos de ",
  Cell[BoxData[
      \(TraditionalForm\`1\/150\)]],
  ".\nb) Transforma lista1 en otra lista, que llamar\[AAcute]s \"lista2\", en \
la que cada elemento {x,x}\[Element]lista1 se ha reemplazado por ",
  Cell[BoxData[
      \(TraditionalForm\`{x\/\(1 + x\^2\), \ tg( .5 + x)}\)]],
  ".\nc) Calcula la suma de los elementos de lista2.\nd) Define la funci\
\[OAcute]n (x,y) \[RightTeeArrow] ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\  + \ 2  y\)\/\(1 + \ x\^2\  - \ y\^2\)\)]],
  " y la eval\[UAcute]as en los elementos de lista2 y a la lista resultante \
la llamas \"lista3\".\ne) Selecciona en lista3 los elementos mayores que -3 y \
menores que 3.\nf) Calcula el producto de los elementos de la lista obtenida \
en el apartado anterior."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[BoxData[{
    \(lista1 = Table[{x, x}, {x, 0. , 1, 1. /150}]; \n
    func[{x_, y_}] = {x\/\(1 + x\^2\), \ Tan[ .5 + x]}; \n
    lista2 = Map[func, lista1]; \nApply[Plus, lista2]\), 
    \(newfunc[{x_, y_}] = \(x\  + \ 2  y\)\/\(1 + \ x\^2\  - \ y\^2\); \n
    lista3 = Map[newfunc, lista2]; \nselecciona[x_] := \(-3\) < x < 3; \n
    Select[lista3, selecciona]; \nApply[Times, %]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comentarios", "Subsection"],

Cell["\<\
Pueden usarse reglas de sustituci\[OAcute]n en vez de usar funciones y el \
comando Map[ ]. \
\>", "Text"],

Cell[BoxData[{
    \(lista2new = lista1 /. {x_, x_} -> {x\/\(1 + x\^2\), \ Tan[ .5 + x]}; \n
    lista2new == lista2\), 
    \(lista3new = 
      lista2 /. {x_, y_} -> \(x\  + \ 2  y\)\/\(1 + \ x\^2\  - \ y\^2\); \n
    lista3new == lista3\)}], "Input"],

Cell[TextData[{
  "Aunque esta forma de proceder parece m\[AAcute]s c\[OAcute]moda, es m\
\[AAcute]s peligrosa porque no siempre es f\[AAcute]cil controlar la forma en \
que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " aplica una regla de sustituci\[OAcute]n. F\[IAcute]jate en el siguienete \
ejemplo en el que una misma regla parece hacer cosas distinttas en cada caso \
y procura entender lo que pasa."
}], "Text"],

Cell[BoxData[{
    \({{a, b}, {c, d}} /. {x_, y_} -> {x + y, x - y}\), 
    \(\t{{a, b}, {c, d}, {u, v}} /. {x_, y_} -> {x + y, x - y}\)}], "Input"],

Cell["\<\
Como precauci\[OAcute]n, cuando uses reglas de sustituci\[OAcute]n es \
conveniente condicionar las variables.\
\>", "Text"],

Cell[BoxData[{
    \({{1, 4}, {3, 7}} /. {x_, y_} -> {x + y, x - y}\), 
    \(\t{{1, 4}, {3, 7}} /. {x_?NumberQ, y_?NumberQ} -> {x + y, x - y}\)}], 
  "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell[TextData["Para cada n\[Element]N sea"], "Text"],

Cell[BoxData[
    \(TextForm
    \`P \((n, x)\) = 
      \(\(x - x\^3\/\(3!\) + x\^5\/\(5!\) - x\^7\/\(7!\) +  ... \) + 
          \(\((\(-1\))\)\^\(n + 1\)\) x\^\(2  n - 1\)\/\(\((2  n - 1)\)!\) = 
        \[Sum]\+\(k = 1\)\%n\(\((\(-1\))\)\^\(k + 1\)\) 
            x\^\(2  k - 1\)\/\(\((2  k - 1)\)!\)\)\)], "Text",
  TextAlignment->Center],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que en cada gr\[AAcute]fica \
se representan juntas las funciones sen(x) y P(n,x) en el intervalo \
[-5Pi,5Pi]. Debes dar valores a n desde n=2 hasta n=20 con incrementos de 2 \
unidades. La funci\[OAcute]n sen(x) debe tener color rojo y la \
funci\[OAcute]n P(n,x) azul y ambas deben tener grosor 0.007. Debes fijar el \
mismo rango para todas ellas.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[BoxData[
    \(Animate[\n\t
      Plot[{Sin[x], 
          \[Sum]\+\(k = 1\)\%n\(\((\(-1\))\)\^\(k + 1\)\) 
              x\^\(2  k - 1\)\/\(\((2  k - 1)\)!\)}, {x, \(-5\) Pi, 5  Pi}, 
        PlotRange -> {\(-6\), 6}, 
        PlotStyle -> {{Hue[0], Thickness[ .007]}, {Hue[ .65], 
              Thickness[ .007]}}], {n, 2, 20, 2}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comentarios", "Subsection"],

Cell["\<\
En vez de Animate[ ] puede usarse Table[ ] o Do[ ]. El fallo principal que ha \
habido e este ejercicio ha sido debido a que algunos intent\[AAcute]is \
representar con Plot[ ] el pilnomio P(n,x) y eso no puede hacerse porque, \
adem\[AAcute]s de la variable real x, P(n,x) depende de un par\[AAcute]metro \
n que toma valores naturales y si no se da un valor a dicho par\[AAcute]metro \
es imposible evaluar dicha funci\[OAcute]n. Precisamente, lo que hacen los \
comandos  Animate[ ] , Table[ ] o Do[ ] es ir dando valores a n y haciendo \
las correspondientes representaciones.\
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowSize->{962, 595},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 57, 0, 56, "Subsection"],
Cell[1791, 53, 1503, 29, 262, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3331, 87, 39, 0, 56, "Subsection"],
Cell[3373, 89, 457, 13, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3867, 107, 50, 0, 56, "Subsection"],
Cell[3920, 109, 117, 3, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4074, 117, 33, 0, 56, "Subsection"],
Cell[4110, 119, 1096, 21, 243, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5243, 145, 38, 0, 56, "Subsection"],
Cell[5284, 147, 398, 6, 261, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5719, 158, 33, 0, 56, "Subsection"],
Cell[5755, 160, 116, 3, 33, "Text"],
Cell[5874, 165, 253, 5, 154, "Input"],
Cell[6130, 172, 431, 9, 54, "Text"],
Cell[6564, 183, 148, 2, 81, "Input"],
Cell[6715, 187, 134, 3, 33, "Text"],
Cell[6852, 192, 159, 3, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7048, 200, 33, 0, 56, "Subsection"],
Cell[7084, 202, 52, 0, 33, "Text"],
Cell[7139, 204, 343, 7, 70, "Text"],
Cell[7485, 213, 423, 7, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7945, 225, 38, 0, 56, "Subsection"],
Cell[7986, 227, 350, 7, 164, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8373, 239, 33, 0, 56, "Subsection"],
Cell[8409, 241, 604, 9, 96, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

